/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.IDamageSource;
import noppes.npcs.api.IEntityDamageSource;
import noppes.npcs.api.IMethods;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.entity.data.INpcAttribute;
import noppes.npcs.api.entity.data.IPlayerMail;
import noppes.npcs.api.gui.ICustomGui;
import noppes.npcs.api.handler.IAnimationHandler;
import noppes.npcs.api.handler.IBorderHandler;
import noppes.npcs.api.handler.ICloneHandler;
import noppes.npcs.api.handler.ICustomPlayerData;
import noppes.npcs.api.handler.IDialogHandler;
import noppes.npcs.api.handler.IDimensionHandler;
import noppes.npcs.api.handler.IFactionHandler;
import noppes.npcs.api.handler.IKeyBinding;
import noppes.npcs.api.handler.IMarcetHandler;
import noppes.npcs.api.handler.IQuestHandler;
import noppes.npcs.api.handler.IRecipeHandler;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.BlockWrapper;
import noppes.npcs.api.wrapper.ContainerWrapper;
import noppes.npcs.api.wrapper.DamageSourceWrapper;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.NBTWrapper;
import noppes.npcs.api.wrapper.NpcEntityDamageSource;
import noppes.npcs.api.wrapper.WorldWrapper;
import noppes.npcs.api.wrapper.WrapperEntityData;
import noppes.npcs.api.wrapper.data.AttributeWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiWrapper;
import noppes.npcs.client.gui.util.IResourceData;
import noppes.npcs.client.util.ResourceData;
import noppes.npcs.containers.ContainerNpcInterface;
import noppes.npcs.controllers.AnimationController;
import noppes.npcs.controllers.BorderController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.KeyController;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.dimensions.DimensionHandler;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.LRUHashMap;
import noppes.npcs.util.NBTJsonUtil;
import noppes.npcs.util.Util;

public class WrapperNpcAPI
extends NpcAPI {
    public static volatile LRUHashMap<Integer, WorldWrapper> worldCache = new LRUHashMap(300);
    private static NpcAPI instance = null;
    private static final Comparator<World> sorter = (w_0, w_1) -> {
        String dimName0 = w_0.field_73011_w.func_186058_p().func_186065_b();
        String dimName1 = w_1.field_73011_w.func_186058_p().func_186065_b();
        if ("overworld".equals(dimName0)) {
            return -1;
        }
        if ("overworld".equals(dimName1)) {
            return 1;
        }
        return Integer.compare(w_0.field_73011_w.getDimension(), w_1.field_73011_w.getDimension());
    };
    public static EventBus EVENT_BUS = new EventBus();
    private final List<World> worlds = Lists.newArrayList();

    public static void clearCache() {
        worldCache.clear();
        BlockWrapper.clearCache();
    }

    public static NpcAPI Instance() {
        if (instance == null) {
            instance = new WrapperNpcAPI();
        }
        return instance;
    }

    public static void resetScriptControllerData(NBTTagCompound compound) {
        WorldWrapper.getStoredData().setNbt(new NBTWrapper(compound));
    }

    private void checkWorld() {
        if (CustomNpcs.Server != null && CustomNpcs.Server.func_71241_aa()) {
            throw new CustomNPCsException("No world is loaded right now", new Object[0]);
        }
    }

    @Override
    public ICustomGui createCustomGui(int id, int width, int height, boolean pauseGame) {
        return new CustomGuiWrapper(id, width, height, pauseGame, null);
    }

    @Override
    public IPlayerMail createMail(String sender, String subject) {
        PlayerMail mail = new PlayerMail();
        mail.sender = sender;
        mail.title = subject;
        return mail;
    }

    @Override
    public ICustomNpc<?> createNPC(World world) {
        if (world.field_72995_K) {
            return null;
        }
        EntityCustomNpc npc = new EntityCustomNpc(world);
        return npc.wrappedNPC;
    }

    @Override
    public EventBus events() {
        return EVENT_BUS;
    }

    @Override
    public String executeCommand(IWorld world, String command) {
        FakePlayer player = EntityNPCInterface.CommandPlayer;
        player.func_70029_a(world.getMCWorld());
        player.func_70107_b(0.0, 0.0, 0.0);
        return NoppesUtilServer.runCommand(world.getMCWorld(), BlockPos.field_177992_a, "API", command, null, (ICommandSender)player);
    }

    @Override
    public IPlayer<?>[] getAllPlayers() {
        ArrayList list = Lists.newArrayList();
        if (CustomNpcs.Server != null) {
            for (EntityPlayerMP player : CustomNpcs.Server.func_184103_al().func_181057_v()) {
                if (player == null) continue;
                list.add((IPlayer)this.getIEntity((Entity)player));
            }
        }
        return list.toArray(new IPlayer[0]);
    }

    @Override
    public IAnimationHandler getAnimations() {
        return AnimationController.getInstance();
    }

    @Override
    public IBorderHandler getBorders() {
        return BorderController.getInstance();
    }

    @Override
    public ICloneHandler getClones() {
        return ServerCloneController.Instance;
    }

    @Override
    public IDimensionHandler getCustomDimension() {
        return DimensionHandler.getInstance();
    }

    @Override
    public IDialogHandler getDialogs() {
        return DialogController.instance;
    }

    @Override
    public IFactionHandler getFactions() {
        this.checkWorld();
        return FactionController.instance;
    }

    @Override
    public File getGlobalDir() {
        return CustomNpcs.Dir;
    }

    @Override
    public INpcAttribute getIAttribute(IAttributeInstance mcAttribute) {
        return new AttributeWrapper(mcAttribute);
    }

    @Override
    public IBlock getIBlock(World world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        return BlockWrapper.createNew(world, pos, world.func_180495_p(pos));
    }

    @Override
    public IContainer getIContainer(Container container) {
        if (container instanceof ContainerNpcInterface) {
            return ContainerNpcInterface.getOrCreateIContainer((ContainerNpcInterface)container);
        }
        return new ContainerWrapper(container);
    }

    @Override
    public IContainer getIContainer(IInventory inventory) {
        return new ContainerWrapper(inventory);
    }

    @Override
    public IDamageSource getIDamageSource(DamageSource damagesource) {
        return new DamageSourceWrapper(damagesource);
    }

    @Override
    public IEntityDamageSource getIDamageSource(String name, IEntity<?> entity) {
        return new NpcEntityDamageSource(name, entity);
    }

    @Override
    public IEntity<?> getIEntity(Entity entity) {
        if (entity == null || entity.field_70170_p == null) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            return ((EntityNPCInterface)entity).wrappedNPC;
        }
        return WrapperEntityData.get(entity);
    }

    @Override
    public IItemStack getIItemStack(ItemStack itemstack) {
        if (itemstack == null || itemstack.func_190926_b()) {
            return ItemStackWrapper.AIR;
        }
        return (IItemStack)itemstack.getCapability(ItemStackWrapper.ITEM_SCRIPTED_DATA_CAPABILITY, null);
    }

    @Override
    public IKeyBinding getIKeyBinding() {
        return KeyController.getInstance();
    }

    @Override
    public INbt getINbt(NBTTagCompound compound) {
        if (compound == null) {
            return new NBTWrapper(new NBTTagCompound());
        }
        return new NBTWrapper(compound);
    }

    @Override
    public IPlayer<?> getIPlayer(String nameOrUUID) {
        IPlayer<?>[] iPlayers;
        for (IPlayer<?> iPlayer : iPlayers = this.getAllPlayers()) {
            if (!iPlayer.getName().equals(nameOrUUID) && !iPlayer.getUUID().equals(nameOrUUID)) continue;
            return iPlayer;
        }
        return null;
    }

    @Override
    public IPos getIPos(BlockPos pos) {
        return new BlockPosWrapper(pos);
    }

    @Override
    public IPos getIPos(double x, double y, double z) {
        return new BlockPosWrapper(x, y, z);
    }

    @Override
    public IWorld getIWorld(String dimension) {
        this.resetWorlds();
        for (World world : this.worlds) {
            if (!world.field_73011_w.func_186058_p().func_186065_b().equals(dimension)) continue;
            return this.getIWorld(world);
        }
        if (!Thread.currentThread().getName().toLowerCase().contains("client")) {
            throw new CustomNPCsException("Unknown dimension: \"" + dimension + "\"", new Object[0]);
        }
        return null;
    }

    @Override
    public IWorld getIWorld(int dimensionId) {
        this.resetWorlds();
        for (World world : this.worlds) {
            if (world.field_73011_w.getDimension() != dimensionId) continue;
            return this.getIWorld(world);
        }
        if (!Thread.currentThread().getName().toLowerCase().contains("client")) {
            throw new CustomNPCsException("Unknown dimension: \"" + dimensionId + "\"", new Object[0]);
        }
        return null;
    }

    private void resetWorlds() {
        EntityPlayer player;
        this.checkWorld();
        if (CustomNpcs.Server != null) {
            this.worlds.clear();
            this.worlds.addAll(Arrays.asList(CustomNpcs.Server.field_71305_c));
            this.worlds.sort(sorter);
        }
        if ((player = CustomNpcs.proxy.getPlayer()) != null && !this.worlds.contains(player.field_70170_p)) {
            this.worlds.add(player.field_70170_p);
            this.worlds.sort(sorter);
        }
    }

    @Override
    public IWorld getIWorld(World world) {
        WorldWrapper w = (WorldWrapper)worldCache.get(world.field_73011_w.getDimension());
        if (w != null) {
            if (w.world == null) {
                w.world = world;
            }
        } else {
            w = WorldWrapper.createNew(world);
            worldCache.put(world.field_73011_w.getDimension(), w);
        }
        return w;
    }

    @Override
    public IWorld[] getIWorlds() {
        this.resetWorlds();
        IWorld[] iWorlds = new IWorld[this.worlds.size()];
        for (int i = 0; i < this.worlds.size(); ++i) {
            iWorlds[i] = this.getIWorld(this.worlds.get(i));
        }
        return iWorlds;
    }

    @Override
    public IMarcetHandler getMarkets() {
        return MarcetController.getInstance();
    }

    @Override
    public IMethods getMethods() {
        return Util.instance;
    }

    @Override
    public IQuestHandler getQuests() {
        this.checkWorld();
        return QuestController.instance;
    }

    @Override
    public String getRandomName(int dictionary, int gender) {
        return CustomNpcs.MARKOV_GENERATOR[dictionary].fetch(gender);
    }

    @Override
    public INbt getRawPlayerData(String uuid, String name) {
        if (CustomNpcs.Server != null) {
            PlayerData data;
            UUID uuidMC;
            try {
                uuidMC = UUID.fromString(uuid);
            }
            catch (Exception e) {
                throw new CustomNPCsException("Invalid UUID string: \"" + uuid + "\"", new Object[0]);
            }
            EntityPlayerMP player = CustomNpcs.Server.func_184103_al().func_177451_a(uuidMC);
            if (player != null && player.func_70005_c_().equals(name) && (data = CustomNpcs.proxy.getPlayerData((EntityPlayer)player)) != null) {
                return this.getINbt(data.getNBT());
            }
        }
        return this.getINbt(PlayerData.loadPlayerData(uuid, name));
    }

    @Override
    public IRecipeHandler getRecipes() {
        this.checkWorld();
        return null;
    }

    @Override
    public File getWorldDir() {
        return CustomNpcs.getWorldSaveDirectory();
    }

    @Override
    public boolean hasPermissionNode(String permission) {
        return PermissionAPI.getPermissionHandler().getRegisteredNodes().contains(permission);
    }

    @Override
    public void registerCommand(CommandNoppesBase command) {
        CustomNpcs.NoppesCommand.registerCommand(command);
    }

    @Override
    public void registerPermissionNode(String permission, int defaultType) {
        if (defaultType < 0 || defaultType > 2) {
            throw new CustomNPCsException("Default type cant be smaller than 0 or larger than 2", new Object[0]);
        }
        if (this.hasPermissionNode(permission)) {
            throw new CustomNPCsException("Permission already exists", new Object[0]);
        }
        DefaultPermissionLevel level = DefaultPermissionLevel.values()[defaultType];
        PermissionAPI.registerNode((String)permission, (DefaultPermissionLevel)level, (String)permission);
    }

    @Override
    public ICustomNpc<?> spawnNPC(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return null;
        }
        EntityCustomNpc npc = new EntityCustomNpc(world);
        npc.func_70080_a((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f);
        npc.ais.setStartPos(x, y, z);
        npc.func_70606_j(npc.func_110138_aP());
        world.func_72838_d((Entity)npc);
        return npc.wrappedNPC;
    }

    @Override
    public INbt stringToNbt(String str) {
        if (str == null || str.isEmpty()) {
            throw new CustomNPCsException("Cant cast empty string to nbt", new Object[0]);
        }
        try {
            return this.getINbt(NBTJsonUtil.Convert(str));
        }
        catch (NBTJsonUtil.JsonException e) {
            throw new CustomNPCsException(e, "Failed converting " + str, new Object[0]);
        }
    }

    @Override
    public ICustomPlayerData getPlayerData(EntityPlayer player) {
        return PlayerData.get(player);
    }

    @Override
    public IResourceData getResourceData(ResourceLocation texture, int u, int v, int width, int height) {
        return new ResourceData(texture, u, v, width, height);
    }

    @Override
    public IData getTempdata() {
        return WorldWrapper.getTempData();
    }

    @Override
    public IData getStoreddata() {
        return WorldWrapper.getStoredData();
    }
}

